/*=========================================================

	padutil.c

	pbhf[^B

=========================================================*/
#ifndef PADUTIL_H
#define PADUTIL_H

#include <pspkernel.h>
#include <pspctrl.h>
#include <psphprm.h>
#include <stdlib.h>
#include <math.h>
#include "psp/memory.h"
#include "utils/strutil.h"

/*=========================================================
	}N
=========================================================*/
#define PADUTIL_CENTER_X   127
#define PADUTIL_CENTER_Y   127
#define PADUTIL_MAX_COORD  255
#define PADUTIL_MAX_RADIUS 182 /* ӂ̒ * 2̕ (_ȉ؂グ) */

#define PADUTIL_PAD_NORMAL_BUTTONS (\
	PSP_CTRL_START    |\
	PSP_CTRL_SELECT   |\
	PSP_CTRL_UP       |\
	PSP_CTRL_RIGHT    |\
	PSP_CTRL_DOWN     |\
	PSP_CTRL_LEFT     |\
	PSP_CTRL_LTRIGGER |\
	PSP_CTRL_RTRIGGER |\
	PSP_CTRL_TRIANGLE |\
	PSP_CTRL_CIRCLE   |\
	PSP_CTRL_CROSS    |\
	PSP_CTRL_SQUARE   |\
	PSP_CTRL_HOME     |\
	PSP_CTRL_NOTE     |\
	PSP_CTRL_SCREEN   |\
	PSP_CTRL_VOLUP    |\
	PSP_CTRL_VOLDOWN  \
)

#define PADUTIL_PAD_TOGGLE_BUTTONS (\
	PSP_CTRL_HOLD    |\
	PSP_CTRL_WLAN_UP |\
	PSP_CTRL_REMOTE  |\
	PSP_CTRL_DISC    |\
	PSP_CTRL_MS      \
)

#define PADUTIL_PAD_ANALOGDIR_BUTTONS (\
	PADUTIL_CTRL_ANALOG_UP    |\
	PADUTIL_CTRL_ANALOG_RIGHT |\
	PADUTIL_CTRL_ANALOG_DOWN  |\
	PADUTIL_CTRL_ANALOG_LEFT  \
)

#define PADUTIL_HPRM_NORMAL_KEYS (\
	PSP_HPRM_PLAYPAUSE |\
	PSP_HPRM_FORWARD   |\
	PSP_HPRM_BACK      |\
	PSP_HPRM_VOL_UP    |\
	PSP_HPRM_VOL_DOWN  \
)

#define PADUTIL_HPRM_TOGGLE_KEYS (\
	PSP_HPRM_HOLD \
)

#define PADUTIL_BUTTON_SYMBOLS \
	{ padutilSetPad( PSP_CTRL_SELECT ),           "SELECT" },\
	{ padutilSetPad( PSP_CTRL_START ),            "START"  },\
	{ padutilSetPad( PSP_CTRL_UP ),               "\x80"   },\
	{ padutilSetPad( PSP_CTRL_RIGHT ),            "\x81"   },\
	{ padutilSetPad( PSP_CTRL_DOWN ),             "\x82"   },\
	{ padutilSetPad( PSP_CTRL_LEFT ),             "\x83"   },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_UP ),    "A\x80"  },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_RIGHT ), "A\x81"  },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_DOWN ),  "A\x82"  },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_LEFT ),  "A\x83"  },\
	{ padutilSetPad( PSP_CTRL_LTRIGGER ),         "L"      },\
	{ padutilSetPad( PSP_CTRL_RTRIGGER ),         "R"      },\
	{ padutilSetPad( PSP_CTRL_TRIANGLE ),         "\x84"   },\
	{ padutilSetPad( PSP_CTRL_CIRCLE ),           "\x85"   },\
	{ padutilSetPad( PSP_CTRL_CROSS ),            "\x86"   },\
	{ padutilSetPad( PSP_CTRL_SQUARE ),           "\x87"   },\
	{ padutilSetPad( PSP_CTRL_HOME ),             "HOME"   },\
	{ padutilSetPad( PSP_CTRL_HOLD ),             "HOLD"   },\
	{ padutilSetPad( PSP_CTRL_NOTE ),             "\x88"   },\
	{ padutilSetPad( PSP_CTRL_SCREEN ),           "SCREEN" },\
	{ padutilSetPad( PSP_CTRL_VOLUP ),            "VOL+"   },\
	{ padutilSetPad( PSP_CTRL_VOLDOWN ),          "VOL-"   },\
	{ padutilSetPad( PSP_CTRL_WLAN_UP ),          "WLAN"   },\
	{ padutilSetPad( PSP_CTRL_REMOTE ),           "REMOTE" },\
	{ padutilSetPad( PSP_CTRL_DISC ),             "DISC"   },\
	{ padutilSetPad( PSP_CTRL_MS ),               "MS"     },\
	{ padutilSetHprm( PSP_HPRM_PLAYPAUSE ),       "RPLAY"  },\
	{ padutilSetHprm( PSP_HPRM_FORWARD ),         "RNEXT"  },\
	{ padutilSetHprm( PSP_HPRM_BACK ),            "RPREV"  },\
	{ padutilSetHprm( PSP_HPRM_VOL_UP ),          "RVOL+"  },\
	{ padutilSetHprm( PSP_HPRM_VOL_DOWN ),        "RVOL-"  },\
	{ padutilSetHprm( PSP_HPRM_HOLD ),            "RHOLD"  },\
	{ 0, NULL }

#define PADUTIL_BUTTON_NAMES \
	{ padutilSetPad( PSP_CTRL_SELECT ),           "SELECT"      },\
	{ padutilSetPad( PSP_CTRL_START ),            "START"       },\
	{ padutilSetPad( PSP_CTRL_UP ),               "Up"          },\
	{ padutilSetPad( PSP_CTRL_RIGHT ),            "Right"       },\
	{ padutilSetPad( PSP_CTRL_DOWN ),             "Down"        },\
	{ padutilSetPad( PSP_CTRL_LEFT ),             "Left"        },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_UP ),    "AnalogUp"    },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_RIGHT ), "AnalogRight" },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_DOWN ),  "AnalogDown"  },\
	{ padutilSetPad( PADUTIL_CTRL_ANALOG_LEFT ),  "AnalogLeft"  },\
	{ padutilSetPad( PSP_CTRL_LTRIGGER ),         "LTrigger"    },\
	{ padutilSetPad( PSP_CTRL_RTRIGGER ),         "RTrigger"    },\
	{ padutilSetPad( PSP_CTRL_TRIANGLE ),         "Triangle"    },\
	{ padutilSetPad( PSP_CTRL_CIRCLE ),           "Circle"      },\
	{ padutilSetPad( PSP_CTRL_CROSS ),            "Cross"       },\
	{ padutilSetPad( PSP_CTRL_SQUARE ),           "Square"      },\
	{ padutilSetPad( PSP_CTRL_HOME ),             "HOME"        },\
	{ padutilSetPad( PSP_CTRL_HOLD ),             "HOLD"        },\
	{ padutilSetPad( PSP_CTRL_NOTE ),             "NOTE"        },\
	{ padutilSetPad( PSP_CTRL_SCREEN ),           "SCREEN"      },\
	{ padutilSetPad( PSP_CTRL_VOLUP ),            "VolUp"       },\
	{ padutilSetPad( PSP_CTRL_VOLDOWN ),          "VolDown"     },\
	{ padutilSetPad( PSP_CTRL_WLAN_UP ),          "WLAN"        },\
	{ padutilSetPad( PSP_CTRL_REMOTE ),           "REMOTE"      },\
	{ padutilSetPad( PSP_CTRL_DISC ),             "DISC"        },\
	{ padutilSetPad( PSP_CTRL_MS ),               "MS"          },\
	{ padutilSetHprm( PSP_HPRM_PLAYPAUSE ),       "RPlayPause"  },\
	{ padutilSetHprm( PSP_HPRM_FORWARD ),         "RForward"    },\
	{ padutilSetHprm( PSP_HPRM_BACK ),            "RBack"       },\
	{ padutilSetHprm( PSP_HPRM_VOL_UP ),          "RVolUp"      },\
	{ padutilSetHprm( PSP_HPRM_VOL_DOWN ),        "RVolDown"    },\
	{ padutilSetHprm( PSP_HPRM_HOLD ),            "RHOLD"       },\
	{ 0, NULL }

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================
	^錾
=========================================================*/
typedef uint64_t      PadutilButtons;
typedef unsigned char PadutilCoord;
typedef char          PadutilRelCoord;
typedef float         PadutilSensitivity;

typedef struct {
	PadutilCoord       originX;
	PadutilCoord       originY;
	PadutilCoord       deadzone;
	PadutilSensitivity sensitivity;
} PadutilAnalogStick;

typedef struct PadutilRemap {
	PadutilButtons realButtons;
	PadutilButtons remapButtons;
	struct PadutilRemap *prev;
	struct PadutilRemap *next;
} PadutilRemap;

typedef struct {
	PadutilButtons button;
	char *name;
} PadutilButtonName;

/*
	AiOpbh̕i[B
	{^R[hƂĎgpAenum PspCtrlButtonsgpĂȂ󂫃rbggpB
*/
typedef enum {
	PADUTIL_CTRL_ANALOG_UP    = 0x00000002,
	PADUTIL_CTRL_ANALOG_RIGHT = 0x00000004,
	PADUTIL_CTRL_ANALOG_DOWN  = 0x00000400,
	PADUTIL_CTRL_ANALOG_LEFT  = 0x00000800
} PadutilAnalogDirection;

typedef enum {
	PADUTIL_OPT_TOKEN_SP  = 0x00000001,
	PADUTIL_OPT_IGNORE_SP = 0x00000002,
	PADUTIL_OPT_CASE_SENS = 0x00000004,
} PadutilOption;

/*=========================================================
	֐
=========================================================*/
PadutilButtonName *padutilCreateButtonSymbols( void );
PadutilButtonName *padutilCreateButtonNames( void );
void padutilDestroyButtonList( PadutilButtonName *name );

/*-----------------------------------------------
	padutilGetButtonNamesByCode
	
	w肳ꂽ{^R[h{^Xgƃf~^ɏ]ĕ񉻂B
-----------------------------------------------*/
char *padutilGetButtonNamesByCode( PadutilButtonName *availbtn, PadutilButtons buttons, const char *delim, unsigned int opt, char *buf, size_t len );

/*-----------------------------------------------
	padutilGetButtonCodeByNames
	
	{^̑gݍ킹f~^ŋ؂ă{^XgƏƍA{^R[hɕϊB
	{^𒼐ڑ삷邽߁A͔̕j󂳂B
	̕񂪕Kvłꍇ́ARs[nƁB
-----------------------------------------------*/
PadutilButtons padutilGetButtonCodeByNames( PadutilButtonName *availbtn, char *names, const char *delim, unsigned int opt );

/*-----------------------------------------------
	padutilGetAnalogStickDirection
	
	AiOXeBbN̏㉺EAƎ`AiOXeBbNR[hŕԂB
	AiOXeBbNR[h́AʏPSP{^R[hgpĂȂԂgpĂB
-----------------------------------------------*/
unsigned int padutilGetAnalogStickDirection( PadutilCoord x, PadutilCoord y, PadutilCoord deadzone );

/*-----------------------------------------------
	padutilSetAnalogStickDirection
	
-----------------------------------------------*/
void padutilSetAnalogStickDirection( unsigned int analog_direction, PadutilCoord *x, PadutilCoord *y );

/*-----------------------------------------------
	padutilCreateRemapArray
	
	}bv`p̔z쐬B
	PadutilRemap͑oNXgł邪A
	gƂɂAnext/prevO̗vfwz쐬łB
	SĂ̗vf͔ẑ悤ɗׂ荇Ă邽߁Afor|C^ZŊȒPɉ񂹂B
	
	vfړImemsetȂǂŃ[NAĂ͂ȂB
	炩ߐݒ肳ꂽnext/prev܂Ń[NAĂ܂B
	vfrealButtons/remapButtons͎Iɂ0ŏ邽߁A
	߂ďKv͂ȂB
-----------------------------------------------*/
PadutilRemap *padutilCreateRemapArray( size_t count );

/*-----------------------------------------------
	padutilDestroyRemapArray
	
	PadutilCreateRemapArray()ō쐬zB
-----------------------------------------------*/
void padutilDestroyRemapArray( PadutilRemap *remap );

void padutilAdjustAnalogStick( const PadutilAnalogStick *analogstick, SceCtrlData *pad );
void padutilRemap( PadutilRemap *remap, PadutilButtons src, SceCtrlData *pad, u32 *hprmkey, bool redefine );

/*-----------------------------------------------
	padutilSetPad
	padutilSetHprm
	
	PadutilButtons^ɂ͂̃}Nă{^ZbgB
	
	padutilSetPad̓{^f[^ZbgBƂ͂A
	̂Ƃۂɂ͉ĂȂB
	
	padutilSetHprm̓R̃L[f[^ZbgB
	rbg炵ă{^f[^ƏdȂȂ悤ɂĂ邽߁AK̃}NʂȂ΂ȂB
	
	PadutilButtons^ցApbh{^ƃRL[gݍ킹ăZbgꍇ́A
	ꂼ̕Ԃl̘_anB
	    PadutilButtons buttons = padutilSetPad( PSP_CTRL_START ) | padutilSetHprm( PSP_HPRM_PLAYPAUSE );
	
	@param: uint32_t btn
		enum PspCtrlButtonsenum PspHprmKeys̒lB
	
	@return uint64_t
		ϊꂽlB
-----------------------------------------------*/
#define padutilSetPad( btn )  ( (PadutilButtons)( btn ) )
#define padutilSetHprm( btn ) ( (PadutilButtons)( (PadutilButtons)( btn ) << 32 ) )

/*-----------------------------------------------
	padutilGetPad
	padutilGetHprm
	
	PadutilButtons^ɂ͂̃}Năf[^𒊏oB
	
	padutilGetPad̓{^f[^oB
	
	padutilGetHprm̓R̃L[f[^oB
		
	@param: uint64_t btn
		padutilButtons()}NŐlB
	
	@return uint32_t
		oꂽlB
-----------------------------------------------*/
#define padutilGetPad( btn )  ( (unsigned int)btn )
#define padutilGetHprm( btn ) ( (u32)( (PadutilButtons)( btn ) >> 32 ) )


#ifdef __cplusplus
}
#endif

#endif

